/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.formatting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.ui.editor.PHPSourceViewerConfiguration;
import com.aptana.editor.php.internal.ui.editor.formatting.AbstractPHPAutoEditStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;

public class SwitchCaseAutoEditStrategy
extends AbstractPHPAutoEditStrategy {
    private StringBuilder buffer = new StringBuilder();
    private Set<String> sameIndentMatch = new HashSet<String>(Arrays.asList("PHP_CASE", "PHP_DEFAULT"));
    private Set<String> lowerIndentMatch = new HashSet<String>(Arrays.asList("PHP_SWITCH"));

    public SwitchCaseAutoEditStrategy(String contentType, PHPSourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(contentType, configuration, sourceViewer);
    }

    @Override
    protected boolean isValidAutoInsertLocation(IDocument document, DocumentCommand command) {
        if (command.text == null) {
            return false;
        }
        return command.text.endsWith("e") || command.text.endsWith("t");
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        try {
            String incompleteWord = null;
            String completeWord = null;
            if (command.text.endsWith("t")) {
                incompleteWord = "defaul";
                completeWord = "default";
            } else if (command.text.endsWith("e")) {
                incompleteWord = "cas";
                completeWord = "case";
            } else {
                return;
            }
            String type = document.getContentType(command.offset);
            if (!"__php__dftl_partition_content_type".equals(type)) {
                return;
            }
            if (command.offset < incompleteWord.length() + 1) {
                return;
            }
            int length = incompleteWord.length();
            if (!document.get(command.offset - length, length).equals(incompleteWord)) {
                return;
            }
            this.indentSwitchCase(completeWord, document, command);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error in the PHP 'switch-case' auto-indent strategy", (Throwable)e);
        }
    }

    private void indentSwitchCase(String completeWord, IDocument document, DocumentCommand command) throws BadLocationException {
        int startOffset = command.offset - completeWord.length() + 1;
        int lineNumber = document.getLineOfOffset(command.offset);
        IRegion lineInfo = document.getLineInformation(lineNumber);
        int lineOffset = lineInfo.getOffset();
        String startLine = document.get(lineOffset, startOffset - lineOffset);
        if (startLine.trim().length() == 0) {
            this.buffer.setLength(0);
            this.matchIndent(document, this.buffer, lineNumber, startOffset, this.sameIndentMatch, this.lowerIndentMatch);
            String bufferString = this.buffer.toString();
            if (!bufferString.equals(startLine)) {
                command.length += command.offset - lineOffset;
                command.offset = lineOffset;
                command.text = String.valueOf(bufferString) + completeWord;
            }
        }
    }
}

